#ifndef SEP_SYNC_API_H
#define SEP_SYNC_API_H
/*
   *  Object          : sep_sync.h
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:26:15 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief this file containes the functions that used as semaphore function in the SEP software..
   *
   *  \version sep_sync.h#1:csrc:3
   *  \author avis
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include "DX_VOS_basetypes.h"

/******************* Private Functions declerations *************/

/************************ Public Functions **********************/

/**
* @brief This function synchronize the access to the hardware.
*
* The DX_SEP_SemInit function check that the 
*
* @return DxUint32_t - ECC is returned, 
*                        
*/
void DX_SEP_SemInit_ROM();

/**
 * @brief This function synchronize the access to the hardware.
 *
 * The DX_SEP_SemWait function check that the 
 *
 * @return DxUint32_t - ECC is returned, 
 *                        
 */
 

DxUint32_t DX_SEP_SemWait_ROM();

/**
 * @brief This function release the interrupts hardware synchronization.
 *
 */
DxUint32_t DX_SEP_SemGive_ROM();


#ifdef DX_SEP_ROM_VERSION
#ifdef DX_SEP_CC50
#define DX_SEP_SemWait DX_SEP_SemWait_ROM
#define DX_SEP_SemGive DX_SEP_SemGive_ROM
#else
#define DX_SEP_SemWait()    CRYS_OK 
#define DX_SEP_SemGive() 
#endif
#else
#define DX_SEP_SemInit DX_SEP_SemInit_ROM
#define DX_SEP_SemWait DX_SEP_SemWait_ROM
#define DX_SEP_SemGive DX_SEP_SemGive_ROM
#endif
#endif




